// Binary search
// 
// Simplified code as example for the binary search algorithm.
//
// by feyd//godX.de

#include <vector>
#include <string>
#include <stdio.h>

// Base class, binary search
template<class _TYPE>
class CBinarySearch : public std::vector<_TYPE>
{
public:
	CBinarySearch() {}
	virtual ~CBinarySearch() {}

	size_t NearestKey(const _TYPE& key, bool bMatch)
	{
		size_t nLowerBound = 0;
		size_t nUpperBound = std::vector<_TYPE>::size();
		while(true)
		{
			size_t nSize = nUpperBound-nLowerBound;
			if(nSize==0)
				break;
			size_t nMiddle = nLowerBound+nSize/2;
			int nCompare = Compare((*this)[nMiddle], key);
			if(nCompare<0)
			{
				nLowerBound = nMiddle+1;
			} else if(nCompare>0) {
				nUpperBound = nMiddle;
			} else {
				while(bMatch && nLowerBound<nMiddle && Compare((*this)[nMiddle-1], key)==0)
					nMiddle--;
				return nMiddle;
			}
		}
		if(bMatch)
			return std::vector<_TYPE>::size();
		return nLowerBound;
	}
	
	size_t InsertKey(const _TYPE& key)
	{
		size_t nNearest = NearestKey(key, false);
		insert(std::vector<_TYPE>::begin()+nNearest, key);
		return nNearest;
	}

	void RemoveKey(const _TYPE& key)
	{
		while(true)
		{
			size_t nFind = NearestKey(key, true);
			if(nFind==std::vector<_TYPE>::size())
				break;
			erase(std::vector<_TYPE>::begin()+nFind);
		}
	}
	
	size_t FindKey(const _TYPE& key)
	{
		return NearestKey(key, true);
	}

	size_t IsKey(const _TYPE& key)
	{
		return (NearestKey(key, true)==std::vector<_TYPE>::size())?false:true;
	}
protected:
	virtual int Compare(const _TYPE& left, const _TYPE& right) = 0;
};

// Derived specialised class
class CBinarySearch_String : public CBinarySearch<std::string>
{
public:
	CBinarySearch_String() {}
	virtual ~CBinarySearch_String() {}
protected:
	virtual int Compare(const std::string& left, const std::string& right)
	{
		return left.compare(right);
	}
};

// Application entry point (from libc)
int main(int argc, const char* argv[])
{
	printf("Binary search test...\r\n\r\n");

	{
		// by std::string
		printf("std::string:\r\n");
		
		CBinarySearch_String search;
		for(int n=1; n<argc-1; n++)
			search.InsertKey(argv[n]);

		printf("   sorted %d elements:\r\n", (int)search.size());
		for(size_t n=0; n<search.size(); n++)
			printf("      %d. %s\r\n", (int)n+1, search[n].c_str());
		printf("\r\n");

		if(argc>0)
		{
			size_t nPosition = search.FindKey(argv[argc-1]);
			if(nPosition==search.size())
			{
				printf("   element not found\r\n\r\n");
			} else {
				printf("   element found at position %d\r\n\r\n", (int)nPosition+1);
			}
			search.RemoveKey(argv[argc-1]);
			printf("   result %d elements:\r\n", (int)search.size());
			for(size_t n=0; n<search.size(); n++)
				printf("      %d. %s\r\n", (int)n+1, search[n].c_str());
			printf("\r\n");
		}
	}
}
